


service =
{
checkPlayerUnits = function(player)
calls.enter("service.checkPlayerUnits",player)
	local able = false
	local log_id = "undertaker"
	local killed = false

	local check = function(index, name)
		if (healthOK(name)) then
			able = true
			return(1)
		end
	end
	
	local kill = function(index, id)
		if(IsAlive(id)) then
			log(log_id, "Killing", id)
			if (getPersonParameter(id, "HEALTH")>0) then
				killed = true
				setPersonParameter(id, "HEALTH", 0)
			end
		end
	end
	
	if (player == PLAYER) then
		if (CUR_MISSION.Mercs ~= nil) then
			table.foreach(CUR_MISSION.Mercs, check)
		end
	else
		if (CUR_MISSION.Units[player] ~= nil) then
			table.foreach(CUR_MISSION.Units[player], check)
		end
	end
	
	if(not able) then
		log(log_id, player, "don't have any able units")
		if (player == PLAYER) then
			if (CUR_MISSION.Mercs ~= nil) then
				table.foreach(CUR_MISSION.Mercs, kill)
				if (killed) then
					Sectors[CUR_MISSION.Name].onKill()
				end
			end
			CUR_MISSION.Failed = true
		else
			if (CUR_MISSION.Units[player] ~= nil) then
				table.foreach(CUR_MISSION.Units[player], kill)
				if (killed) then
					Sectors[CUR_MISSION.Name].onKill()
				end
			end
		end
	end
calls.leave("service.checkPlayerUnits")
	return(able)
end,

remarksMgr = function(name, event, target)
calls.enter("service.remarksMgr",name..","..event)
	if( (not service.isPlayer(name)) and 
		healthOK(name) and 
		(math.random() < 0.5)) then
		local up = 5
		local who = "enemy"
		local remark = ""
		local litera = ""
		local zero = "0"
	
		if(service.isSniper(name)) then
			who = "sniper"
		elseif(service.isPatrol(name)) then
			who = "patrol"
		elseif(service.isLeader(name)) then
			who = "leader"
		elseif(service.isCivilian(name)) then
			who = "civilian"
		else
			if((event ~= "KILLED_ENEMY") and (event ~= "ENEMY_WOUNDED")) then
				up = 10
			end
		end

		local count = math.random(up)
		if (count > 9) then
			zero = ""
		end

		local selectLitera = function()
			if(isValid(Humans[target])) then
				if (string.lower(getPersonParameterStr(target, "SEX")) == "female") then
					litera = "f_"
				end
			end
		end
	
		if((event == "ENEMY_WOUNDED") and (who ~= "sniper") and (who ~= "civilian")) then
			remark = "_hitted_"
		elseif((event == "KILLED_ENEMY") and (who ~= "civilian")) then
			remark = "_killed_"
		elseif((event == "SHOOTING") and (who ~= "civilian") and (who ~= "sniper")) then
			selectLitera()
			remark = "_taunt_"
		elseif ((event == "HAND_ATTACK") and (who ~= "civilian") and (who ~= "sniper")) then
			selectLitera()
			remark = "_taunt_hand_"
		elseif((event == "KNIFE_ATTACK") and (who ~= "civilian") and (who ~= "sniper")) then
			selectLitera()
			remark = "_taunt_knife_"
		end

		if(remark ~= "") then
			remark = litera..who..remark..zero..count
			service.showAck(name, remark, 1.0)
		end
	end
calls.leave("service.remarksMgr",name..","..event)
end,
------------------------------------------------
--      
--    (id1)    (id2),    
--      -  true
compareIfPosesOK = function(id1, id2)
calls.enter("service.compareIfPosesOK",id1..","..id2)
	local pose1 = getPersonPose(id1)
	local pose2 = getPersonPose(id2)
	
	log(id1, ">> comparing poses of", id1, "and", id2)
	
	if ((pose1 == "lie") or  (pose1 == pose2) or ((pose1 == "sit") and (pose2 ~= "lie"))) then
		log(id, ">>> bad poses:", pose1, "->", pose2)
calls.leave("service.compareIfPosesOK",0)
		return false
	end
	
	log(id1, ">>> poses OK:", pose1, "->", pose2)
calls.leave("service.compareIfPosesOK",1)
	return true
end,
------------------------------------------------
--          
isFriendInLos = function(shooter, target)
calls.enter("service.isFriendInLos",shooter..","..target)
	local log_id = shooter.."_LOS"
	local friends = service.getHumanList(shooter, "ally", false)
	local dist_to_target = service.person2person_distance(shooter, target)
	local res = false
	
	log(log_id, "> Checking for friends in LOS. Target", target)
	
	local checkFriends = function(index, friend)
		local dist_to_friend = service.person2person_distance(shooter, friend)
		local dist_between_friend_and_target = service.person2person_distance(friend, target)
		
		log(log_id, ">> Checking:", friend)
		
		if ((dist_to_friend < dist_to_target) and (dist_between_friend_and_target < dist_to_target)) then
			log(log_id, ">>>>     ")
			--     

			local p = (dist_to_friend+dist_between_friend_and_target+dist_to_target)/2
			local dist_between_friend_and_los = (2*math.sqrt(p*(p-dist_to_friend)*(p-dist_between_friend_and_target)*(p-dist_to_target)))/dist_to_target
			local dist_coef = dist_to_friend / dist_to_target --          . 1    
			local min_delta = 0.5 --         ,   
			local max_delta = 2.0 --      -     
			local delta = max_delta * dist_coef
				
			if (delta < min_delta) then
				delta = min_delta
			end
				
			if (dist_between_friend_and_los <= delta) then
				log(log_id, ">>>>>     ", dist_between_friend_and_los, "<=", delta)
				if (service.compareIfPosesOK(shooter, friend) == false) then
					log(log_id, ">>>>>> and his pose is higher - I need to strafe")
					res = true
					return(1)
				else
					log(log_id, ">>>>>> but his pose is lower")
				end
			else
				log(log_id, ">>>>>     ", dist_between_friend_and_los, ">", delta)
			end
		else 
			log(log_id, ">>>>    ")
		end
		log(log_id, ">> Checking done")
	end
	
	table.foreach(friends, checkFriends)
	
	log(log_id, "> All friends have been checked for being in LOS. Need strafe:", res)
calls.leave("service.isFriendInLos")	
	return res
end,
-------------------------------------------------
--     (  )
-- slot -   
-- barrel - primary  secondary (secondary = )
canReload = function(id, slot, barrel)
calls.enter("service.canReload",id)
	log(id, "     ")
	local bar = barrel
	
	if (barrel == 2) then
		bar = "secondary"
	else
		bar = "primary"
	end

	local res = canReloadWeapon(id, slot, bar)
calls.leave("service.canReload")
	return res
end,
-------------------------------------------------
--
reportEnemy2Friends = function(id, target, prob)
calls.enter("service.reportEnemy2Friends",id)
	local report_rnd 	= math.random()
	if((report_rnd < prob) and 
		isValid(Humans[target]) and
		(not isUnitValid(Humans[target].reportedby))) then
		local visible_enemies_list 	= deepcopy(Humans[id].visible_enemies)
		log(id, "  ")
		fighter_tb.reportVisibleEnemyListToOther(id, "ally")
		if (report_rnd > 0.75) then
			service.alertFriends(id, "RED")
		end
		local report = function(name, visible)
			if (name ~= "size") then
				if (visible == true) then
					Humans[name].reportedby = id
				end
			end
		end
		table.foreach(visible_enemies_list, report)
calls.leave("service.reportEnemy2Friends",1)
		return true
	end
calls.leave("service.reportEnemy2Friends",0)	
	return false
end,
-------------------------------------------------
--      /   
-- percent - bool -  true -    ammo/size
--     0-100
ammoLeft = function(id, slot, barrel, percent)
calls.enter("service.ammoLeft",id)
	local bar = barrel
	
	if (barrel == 2) then
		bar = "secondary"
	else
		bar = "primary"
	end

	local res = getNumBulletsInGun(id, slot, bar)
	
	if (percent == true) then
		log(id, "      ")
		res = math.floor(100 * res / getGunCapacity(id, slot))
	else
		log(id, "     ")
	end
calls.leave("service.ammoLeft",res)
	return res
end,
-------------------------------------------------
--     
clipSize = function(id, slot)
calls.enter("service.clipSize",id)
	local res = getGunCapacity(id, slot)
	log(id, "     ")
calls.leave("service.clipSize",res)
	return res
end,
-------------------------------------------------
--       
person2person_distance = function(person_id1, person_id2)
calls.enter("service.person2person_distance",person_id1..","..person_id2)
	local ret = 10000
	if(isUnitValid(person_id1) and isUnitValid(person_id2)) then
		local x1, y1, z1, f1 = getPosition(person_id1)
		local x2, y2, z2, f2 = getPosition(person_id2)
		ret = math.sqrt((x1 - x2)^2 + (y1 - y2)^2 + (z1 - z2)^2)	
	end
calls.leave("service.person2person_distance",ret)
	return ret
end, 
-------------------------------------------------
--      
trigger2person_distance = function(trigger_id, person_id)
calls.enter("service.trigger2person_distance",trigger_id..","..person_id)
	local ret = 10000
	if(isValid(trigger_id) and isUnitValid(person_id)) then
		local x, y, z, f = getPosition(person_id)
		local pos = Triggers[trigger_id].position
		ret = math.sqrt((pos.x - x)^2 + (pos.y - y)^2)	
	end
calls.leave("service.trigger2person_distance",ret)
	return ret
end, 
-------------------------------------------------
--      
person2point_distance = function(person_id, px, py, pz)
calls.enter("service.person2point_distance",person_id)
	local ret = 10000
	if(isUnitValid(person_id) and isValid(px) and isValid(py) and isValid(pz)) then
		local x, y, z, f = getPosition(person_id)
		ret = math.sqrt((x - px)^2 + (y - py)^2 + (z - pz)^2)
calls.leave("service.person2point_distance",ret)
	end
	return ret
end, 
-------------------------------------------------
point2point_distance = function(x1, y1, z1, x2, y2, z2)
calls.enter("service.point2point_distance",person_id)
	local ret = math.sqrt((x1 - x2)^2 + (y1 - y2)^2 + (z1 - z2)^2)
calls.leave("service.point2point_distance",ret)
	return ret
end, 
-------------------------------------------------
--      R  (30-150), ("ahead")
--  (210-330), ("behind")
--  (135-225), ("left")
-- (315-45)	("right")
--  (0-360)  id ("everywhere")
randomPoint = function(id, direction, range)
calls.enter("service.randomPoint",id)
	local vx, vy, vz 	= getPersonOrientation(id)
	local angle 		= 360 * math.random()
	local x, y, z, f	= getPosition(id)
	
	if(direction == "ahead") 	then 
		angle = -30 + 60 * math.random() 
	elseif(direction == "right") then 
		angle = 60 + 60 * math.random() 
	elseif(direction == "behind") 	then 
		angle = 150 +  60 * math.random() 
	elseif(direction == "left") 	then 
		angle = 240 +  60 * math.random() 
	end

	if (angle < 0) then
		angle = angle + 360
	end
	angle = math.rad(angle) + (math.atan2(vy, vx))
	x = x + (range * math.cos(angle))
	y = y + (range * math.sin(angle))
calls.leave("service.randomPoint",id)	
	return x, y, z, f
end,
-------------------------------------------------
randomPointAroundPoint = function(px, py, pz, range)
calls.enter("service.randomPointAroundPoint")
	local angle = math.rad(360 * math.random())
	px = px + (range * math.cos(angle))
	py = py + (range * math.sin(angle))
calls.leave("service.randomPointAroundPoint")	
	return px, py, pz
end,
-------------------------------------------------
--      
--    id    
randomKnownTargetPoint = function(x, y, z, f, vx, vy, direction, range)
calls.enter("service.randomKnownTargetPoint")
	local angle = 360 * math.random()
	if(direction == "left") then 
		angle = 75 + 30 * math.random() 
	elseif(direction == "right") then 
		angle = 255 + 30 * math.random() 
	elseif(direction == "rightbehind") then 
		angle = 320 + 30 * math.random() 					
	elseif(direction == "leftbehind") then 
	        angle = 140 + 30 * math.random() 
	end
	
	angle = math.rad(angle) + math.atan2(vy, vx)
	x = x + (range * math.cos(angle))
	y = y + (range * math.sin(angle))
calls.leave("service.randomKnownTargetPoint")	
	return x, y, z, f
end,
-------------------------------------------------
--      
--    id    
randomTargetPoint = function(target, direction, range)
calls.enter("service.randomTargetPoint",target)
	local vx, vy, vz, vf = getPersonOrientation(target)
	local x, y, z, f = getPosition(target)
	x, y, z, f =  service.randomKnownTargetPoint(x, y, z, f, vx, vy, direction, range)
calls.leave("service.randomTargetPoint",target)	
	return x, y, z, f
end,
-------------------------------------------------
randomSidePoint = function(id, side, range)
calls.enter("service.randomSidePoint",id)
	local vx, vy, vz 		= getPersonOrientation(id)
	local x, y, z, f		= getPosition(id)
	local person_angle		= math.atan2(vy, vx)
	local angle 			= math.deg(person_angle)
	
	if (angle < 0) then
		angle = angle + 360
	end

	log("test_strafe", "id = ",id,"side = ",side,"radians = ",person_angle,"angle = ",angle)

	if(side == "back") then 
		angle = angle + 180
	elseif(side == "right") then 
		angle = angle + 90
	elseif(side == "left")	then 
		angle = angle + 270
	end

	if (angle > 360) then
		angle = angle - 360
	end

	log("test_strafe", "strafe angle = ",angle)	

	angle = math.rad(angle)

	x = x + (range * math.cos(angle))
	y = y + (range * math.sin(angle))
calls.leave("service.randomSidePoint",id)	
	return x, y, z, f
end,
-------------------------------------------------
getKnownPointClockSector = function(x1, y1, vx1, vy1, x, y)
calls.enter("service.getKnownPointClockSector")
	local ret = 0
	if(isValid(x1) and isValid(y1) and isValid(vx1) and isValid(vy1) and isValid(x) and isValid(y)) then
		local angle1 = math.deg(math.atan2(vy1,vx1))
		local angle2 = math.deg(math.atan2(y - y1,x - x1))
		local delta = angle1-angle2
		if (delta <   0) then delta = delta + 360 end
		if (delta > 360) then delta = delta - 360 end
		ret = math.floor(delta/30)
	end
calls.leave("service.getKnownPointClockSector",ret)
	return ret
end,
-------------------------------------------------
getPointClockSector = function(id, x, y)
calls.enter("service.getPointClockSector",id)
	local ret = 0
	if(isUnitValid(id) and isValid(x) and isValid(y)) then
		local x1, y1, z1, f1 = getPosition(id)
		local vx1, vy1, vz1 = getPersonOrientation(id)
		ret = service.getKnownPointClockSector(x1, y1, vx1, vy1, x, y)
	end
calls.leave("service.getPointClockSector",ret)
	return ret
end,
-------------------------------------------------
--  / id_2    id_1 ( )
--    id_2  id_1    " "
getPersonClockSector = function(id1, id2)
calls.enter("service.getPersonClockSector",id1..","..id2)
	local ret = 0
	if(isUnitValid(id1) and isUnitValid(id2)) then
	        local x2, y2, z2, f2 = getPosition(id2)
        	ret = service.getPointClockSector(id1,x2, y2)
	end
calls.leave("service.getPersonClockSector",ret)
	return ret
end,
-------------------------------------------------
--    id       
--  id  -  true
--  id   -     : left, right, ahead, behind
isSurrounded = function(id)
calls.enter("service.isSurrounded",id)
	local human 	= Humans[id]
	local surrounded= false
	local ahead 	= false
	local behind	= false
	local left 	= false
	local right 	= false
	local visible_targets = service.getHumanList(id, "enemy", true)
	local dir 	= "behind"
	local rnd 	= math.random()

	local checkVisible = function(index, value)
		local hour = service.getPersonClockSector(id,value)
		if(service.isTargetDangerous(value)) then
			if((hour < 2) or (hour > 10)) then
				ahead = true
			elseif(hour < 5) then
				right = true
			elseif(hour < 8) then
				behind = true
			else
				left = true
			end
		end
	end
	
	local checkKnown = function(index, value)
		local hour = service.getPointClockSector(id,value.x,value.y)
		if(service.isTargetDangerous(value.id)) then
			if((hour < 2) or (hour > 10)) then
				ahead = true
			elseif(hour < 5) then
				right = true
			elseif(hour < 8) then
				behind = true
			else
				left = true
			end
		end
	end

	table.foreach(visible_targets, checkVisible)
	table.foreach(human.memory.known_enemies, checkKnown)
	if(ahead and behind and left and right) then
		surrounded = true
		log(id, " !!!")
	else
		log(id, "  ")
		if(ahead == false) then
			dir = "ahead"
		elseif(behind == false) then
			dir = "behind"
		elseif(left == false) and (right == "false") then
			if(rnd < 0.5) then
				dir = "left"
			else
				dir = "right"
			end
		elseif(left == false) then
			dir = "left"
		elseif(right == false) then
			dir = "right"
		end
	end
calls.leave("service.isSurrounded")
	return surrounded, dir
end,
--------------------------------------------------
--       id_1  id_2   R  id_2
pointAlongPersonToPersonLine = function(id1, id2, R)
calls.enter("service.pointAlongPersonToPersonLine",id1..","..id2)
	local K=R/service.person2person_distance(id1, id2)
	local x1, y1, z1, f1 = getPosition(id1)
	local x2, y2, z2, f2 = getPosition(id2)
	local x=K*x1+(1-K)*x2
	local y=K*y1+(1-K)*y2
	local z=K*z1+(1-K)*z2
calls.leave("service.pointAlongPersonToPersonLine",id1..","..id2)	
	return x,y,z
end,
--------------------------------------------------
--       id     R  
pointAlongPersonToPointLine = function(id, x2, y2, z2, R)
calls.enter("service.pointAlongPersonToPointLine",id)
	local K=R/service.person2point_distance(id, x2, y2, z2)
	local x1, y1, z1, f1 = getPosition(id)
	local x=K*x1+(1-K)*x2
	local y=K*y1+(1-K)*y2
	local z=K*z1+(1-K)*z2
calls.leave("service.pointAlongPersonToPointLine",id)	
	return x,y,z
end,
--------------------------------------------------
--       id     R  id
pointAlongPointToPersonLine = function(x2, y2, z2, id, R)
calls.enter("service.pointAlongPointToPersonLine",id)
	local K=R/service.person2point_distance(id, x2, y2, z2)
	local x1, y1, z1, f1 = getPosition(id)
	local x=(1-K)*x1+K*x2
	local y=(1-K)*y1+K*y2
	local z=(1-K)*z1+K*z2
calls.leave("service.pointAlongPointToPersonLine",id)	
	return x,y,z
end,
-------------------------------------------------
selectFireMode = function(id, target, dist, strategy)
calls.enter("service.selectFireMode",id)
	local aggro 		= 0
	local phobia 		= string.upper(getPersonParameterStr(id, "PHOBIA"))
	local hated_nation 	= string.upper(getPersonParameterStr(id, "HATED_NATIONALITY"))
	local target_nation 	= string.upper(getPersonParameterStr(target, "NATIONALITY"))
	local isRacist 		= string.upper(getPersonParameterStr(id, "RACIST"))
	local race 		= string.upper(getPersonParameterStr(id, "RACE"))
	local target_race 	= string.upper(getPersonParameterStr(target, "RACE"))
	local isSexist 		= string.upper(getPersonParameterStr(id, "SEXIST"))
	local sex 		= string.upper(getPersonParameterStr(id, "SEX"))
	local target_sex 	= string.upper(getPersonParameterStr(target, "SEX"))

	if(phobia == "PSYCHO") then
		aggro = aggro + 2
		log(id, "   !  :", aggro)
	end

	if(hated_nation == target_nation) then
		aggro = aggro + 1
		log(id, "   ", target_nation, "  !  :", aggro)
	end

	if((isRacist == "YES") and (race ~= target_race)) then
		aggro = aggro + 1
		log(id, "   ", target_race, "  !  :", aggro)
	end

	if(((isSexist == "YES") or (isSexist == "VERY")) and (sex ~= target_sex)) then
		aggro = aggro + 1
		log(id, "  !  :", aggro)
	end

	aggro = aggro / 5
	local aggro_percent = math.floor(aggro * 100)
	log(id, " :", aggro_percent)
	if(math.random() < aggro) then
		setFiringType(id, "burst")
calls.leave("service.selectFireMode",id)
		return
	end

	local WMConst = {}
	WMConst[0] = {}
	WMConst[0][1] = 1.0
	WMConst[0][2] = 0.8
	WMConst[0][3] = 0.6
	WMConst[0][4] = 0.4
	WMConst[0][5] = 0.0 
	table.setn(WMConst[0],5)
	WMConst[1] = {}
	WMConst[1][1] = 0.6
	WMConst[1][2] = 0.6
	WMConst[1][3] = 0.4
	WMConst[1][4] = 0.2
	WMConst[1][5] = 0.0 
	table.setn(WMConst[1],5)
	WMConst[2] = {}
	WMConst[2][1] = 0.2
	WMConst[2][2] = 0.2
	WMConst[2][3] = 0.2
	WMConst[2][4] = 0.1
	WMConst[2][5] = 0.0
	table.setn(WMConst[2],5)
	WMConst[3] = {}
	WMConst[3][1] = 0.0
	WMConst[3][2] = 0.0
	WMConst[3][3] = 0.0
	WMConst[3][4] = 0.0
	WMConst[3][5] = 0.0
	table.setn(WMConst[3],5)

	local isAutoWeapon1 = (string.upper(getPersonParameterStr(target, "SKILL1"))=="AUTO_WEAPS")
	local isAutoWeapon2 = (string.upper(getPersonParameterStr(target, "SKILL2"))=="AUTO_WEAPS")

	local WMindex = tonumber(math.floor(dist*5/service.getWeaponRange(id))+1)
	if(WMindex>5) then
		WMindex = 5
	end
	if(strategy>3) then
		strategy = 3
	end
	local burstRnd = WMConst[strategy][WMindex]
	if(isAutoWeapon1) then
		burstRnd = burstRnd*1.25
	end
	if(isAutoWeapon2) then
		burstRnd = burstRnd*1.25
	end
	if(math.random()<=burstRnd) then
log(id,"Select burst",dist,strategy,burstRnd)
		setFiringType(id, "burst")
	else
log(id,"Select single",dist,strategy)
		setFiringType(id, "single")
	end
calls.leave("service.selectFireMode",id)
end, 

getWeaponRange = function(id)
	local ret = 0
calls.enter("service.getWeaponRange",id)
	for dist = 20, 150, 5 do
		if(isDefWeaponRanged(id,dist)) then
			ret = dist
		else
			break
		end
	end
	log(id,"Weapon range",ret)
calls.leave("service.getWeaponRange",id)
	return(ret)
end,
-------------------------------------------------
--   
closestVisibleEnemy = function(id)	
calls.enter("service.closestVisibleEnemy",id)
	local closest_enemy = NONE
	local distance = 10000
		
	local find_closest_enemy = function(name, visible)
		if(name ~= "size") then
			if(visible and 
				(healthOK(name) or 
				(IsAlive(name) and (math.random() < getAIConst().attackDyingEnemyProb)))) then
				local dist = service.person2person_distance(id, name)
				if(dist<distance) then
					distance = dist
					closest_enemy =	name
				end
			end
		end
	end
	
	if(Humans[id].visible_enemies.size > 0) then
		table.foreach(Humans[id].visible_enemies, find_closest_enemy)
	end
calls.leave("service.closestVisibleEnemy",id)
	return closest_enemy
end,
-------------------------------------------------
--   
closestDangerousEnemy = function(id)	
calls.enter("service.closestDangerousEnemy",id)	
	local closest_enemy = NONE
	local distance = 10000

	local find_closest_enemy = function(name,visible)
		if(name ~= "size") then
			if(visible and service.isTargetDangerous(name)) then
			        local dist = service.person2person_distance(id, name)
				if(dist<distance) then
					distance = dist
					closest_enemy =	name
				end
			end
		end
	end
	
	if (Humans[id].visible_enemies.size > 0) then
		table.foreach(Humans[id].visible_enemies, find_closest_enemy)
	end
calls.leave("service.closestDangerousEnemy",id)		
	return closest_enemy
end,

visibleByWhom = function(id,list)
calls.enter("service.visibleByWhom",id)
	local ret = NONE

	local find = function(index,data)
		if(healthOK(data) and
			(Humans[data].visible_enemies.size > 0) and
			Humans[data].visible_enemies[id]) then
			ret = data
			return(1)
		end		
	end

	table.foreach(list,find)
calls.leave("service.visibleByWhom",ret)
	return(ret)
end,

-------------------------------------------------
--    .
isSquaddy = function(id)	
calls.enter("service.isSquaddy",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		ret = ((behavior == "squaddy") or 
			(behavior == "squaddy_sniper") or 
			(behavior == "patrol_squaddy") or 
			(behavior == "patrol_squaddy_sniper") or 
			(behavior == "squaddy_guard"))
	end
calls.leave("service.isSquaddy",ret)
	return(ret)
end,
-------------------------------------------------
--    .
isPatrol = function(id)	
calls.enter("service.isPatrol",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		local specialization = Humans[id].specialization
		ret = ((behavior == "wandering") or
			(behavior == "patrol") or
			(behavior == "patrol_squaddy_sniper") or
			(behavior == "patrol_squaddy") or
			(behavior == "patrol_leader") or
			(specialization == "patrol"))
	end
calls.leave("service.isPatrol",ret)
	return(ret)
end,
-------------------------------------------------
--    .
isLeader = function(id)	
calls.enter("service.isLeader",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		ret = ((behavior == "patrol_leader") or 
			(behavior == "squad_leader"))
	end
calls.leave("service.isLeader",ret)
	return(ret)
end,
-------------------------------------------------
--    .
isGuard = function(id)	
calls.enter("service.isGuard",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		local specialization = Humans[id].specialization
		ret = ((behavior == "guard") or 
			(behavior == "squaddy_guard") or
			(behavior == "fixed_guard") or 
			(specialization == "guard"))
calls.leave("service.isGuard",ret)
	end
	return(ret)
end,
-------------------------------------------------
--   .
isSniper = function(id)	
calls.enter("service.isSniper",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		local specialization = Humans[id].specialization
		ret = ((behavior == "sniper") or 
			(behavior == "squaddy_sniper") or 
			(behavior == "patrol_squaddy_sniper") or 
			(specialization == "sniper"))
	end
calls.leave("service.isSniper",ret)
	return(ret)
end,
-------------------------------------------------
--   
getSquaddiesList = function(id)	
calls.enter("service.getSquaddiesList",id)
	local squaddies = {}
	if(isValid(Humans[id])) then
		local leader = Humans[id]
		local squad = leader.params
		local find_squaddy = function(index,value)
			if( (value.id~=id) and (squad == value.params) and 
				healthOK(value.id) and (service.isSquaddy(value.id))) then
				table.insert(squaddies,value.id)
			end
		end
		table.foreach(Humans,find_squaddy)
	end
calls.leave("service.getSquaddiesList",id)
	return squaddies
end,
-------------------------------------------------
--   
closestSquaddy = function(id)	
calls.enter("service.closestSquaddy",id)
	local closest_squaddy = NONE
	local distance = 10000
	local squaddies = service.getSquaddiesList(id)

	local find_closest_squaddy = function(index,value)
		local dist = service.person2person_distance(id, value)
		if(dist<distance) then
			distance = dist
			closest_squaddy = value
		end
	end
	
	table.foreach(squaddies,find_closest_squaddy)
calls.leave("service.closestSquaddy",id)
	return closest_squaddy
end,
-------------------------------------------------
--  
alertFriends = function(id, status)
calls.enter("service.alertFriends",id)
	local friends_list = service.getHumanList(id, "ally", false)
	if ((status ~= "YELLOW") and (status ~= "RED") and (status ~= "GREEN")) then
		log("main", "  : [ "..status.." ] | : [ YELLOW ]")
		status = "YELLOW"
	end

	local alert = function(index,value)
		Humans[value].status = status
	end

	table.foreach(friends_list, alert)
calls.leave("service.alertFriends",id)
end,
-------------------------------------------------
--   
alertSquad = function(id, status)
calls.enter("service.alertSquad",id)
	local squaddies_list = service.getSquaddiesList(id)
	if ((status ~= "YELLOW") and (status ~= "RED") and (status ~= "GREEN")) then
		log("main", "  : [ "..status.." ] | : [ YELLOW ]")
		status = "YELLOW"
	end

	local alert = function(index,value)
		Humans[value].status = status
	end

	table.foreach(squaddies_list, alert)
calls.leave("service.alertSquad",id)
end,
-------------------------------------------------
--   
checkStalkers = function(id, target)	
calls.enter("service.checkStalkers",id)
	local stalkers = 0
	local idTeam = team(id)

	local check_target = function(human, data)
		if((human~=id) and 
			healthOK(human) and
			(relations(idTeam,team(human))==ALLY) and
			(data.known == target) and 
			(not service.isGuard(human))) then
			stalkers = stalkers + 1
		end
	end
	
	table.foreach(Humans, check_target)
calls.leave("service.checkStalkers",stalkers)
	return stalkers
end,

getFarestStalker = function(id, target)	
calls.enter("service.getFarestStalker",id)
	local stalker = NONE
	local maxDist = 0
	local idTeam = team(id)
	
	local check_target = function(human, data)
		if((human~=id) and 
			(relations(idTeam,team(human))==ALLY) and 
			healthOK(human)) then
			if((data.known == target) and (not service.isGuard(human))) then
				local dist = service.person2person_distance(human, target)
				if(dist>maxDist) then
					stalker = human
					maxDist = dist
				end
			end
		end
	end
	
	table.foreach(Humans,check_target)
calls.leave("service.getFarestStalker",id)
	return stalker, maxDist
end,

-------------------------------------------------
--    
checkSoundStalkers = function(id, target)	
calls.enter("service.checkSoundStalkers",id)
	local stalkers = 0
	local idTeam = team(id)
	
	local check_target = function(human, data)
		if((human~=id) and 
			healthOK(human) and
			(relations(idTeam,team(human))==ALLY) and
			(data.check == target) and 
			(not service.isGuard(human))) then
			stalkers = stalkers + 1
		end
	end
	
	table.foreach(Humans,check_target)
calls.leave("service.checkSoundStalkers",stalkers)
	return stalkers
end,

getFarestSoundStalker = function(id, sound)	
calls.enter("service.getFarestSoundStalker",id)
	local stalker = NONE
	local maxDist = 0
	local idTeam = team(id)
	
	local check_target = function(human, data)
		if((human~=id) and 
			(relations(idTeam,team(human))==ALLY) and 
			healthOK(human)) then
			if((data.check == sound.soundID) and (not service.isGuard(human))) then
				local dist = service.person2point_distance(human, sound.x, sound.y, sound.z)
				if(dist>maxDist) then
					stalker = human
					maxDist = dist
				end
			end
		end
	end
	
	table.foreach(Humans,check_target)
calls.leave("service.getFarestSoundStalker",id)
	return stalker, maxDist
end,
-------------------------------------------------
getListSize = function(list)
	calls.enter("service.getListSize")
	local list_size = 0
	if(isValid(list)) then
		local	count =	function(index,	value)
			list_size = list_size + 1
		end
	
		table.foreach(list, count)
	end
calls.leave("service.getListSize",list_size)
	return(list_size)
end,
-------------------------------------------------
areThereDead = function()
calls.enter("service.areThereDead")
	local res = false
	
	local find_dead = function(human, data)
		if not(IsAlive(data.id)) then
			res = true
			return(1)
		end
	end

	table.foreach(Humans, find_dead)
calls.leave("service.areThereDead",res)
	return res
end,
------------------------------------------------
isThereEnemy = function(id)
calls.enter("service.isThereEnemy",id)
	local res = false
	local idTeam = team(id)
	
	local check = function(human, data)
		if(IsAlive(human) and (relations(idTeam, team(human))==ENEMY)) then
			res = true
			return(1)
		end
	end
	
	table.foreach(Humans,check)
calls.leave("service.isThereEnemy")	
	return res
end,
-------------------------------------------------
--   
getHumanList = function(id, rel, visible)	
calls.enter("service.getHumanList",id)
	local list = {}
	local team_id = team(id)
	
	local find_human = function(index, human)
		if(healthOK(human.id) and (human.id ~= id)) then
			local team_human = team(human.id)
			local relation = relations(team_id, team_human)
			local canSee = canOneSeeOther(id, human.id)
			if(((canSee and visible) or (not visible)) and
				((relation == rel) or ((rel == ENEMY) and service.isHateThem(id, human.id) ))
				) then
				table.insert(list, human.id)
			end
		end
	end

	table.foreach(Humans, find_human)
calls.leave("service.getHumanList",id)
	return list
end,
-------------------------------------------------
--     
getPlayerUnits = function(player_id)
calls.enter("service.getPlayerUnits",player_id)
	local list = {}
	local _units = 0
	
	local pick = function(index, data)
		if (team(data.id) == player_id) then
			log("_mission_script_init", data.id)
			table.insert(list, data.id)
			_units = _units + 1
		end
	end

	table.foreach(Humans, pick)
	log("_mission_script_init", "total units", _units)
calls.leave("service.getPlayerUnits",player_id)
	return list
end,
-------------------------------------------------
--    
getLootList = function(id,checkAll)	
calls.enter("service.getLootList",id)
	local list = {}
	
	local find_body = function(index,value)
		if(isUnitValid(value.id) and (not healthOK(value.id))) then
			table.insert(list,value.id)
		end
	end

	local addKnown = function(index,known)
	        if(known and isUnitValid(index)) then
	        	table.insert(list,index)
	        end
	end
	
	if(checkAll) then
		table.foreach(Humans,find_body)
	else
		table.foreach(KnownDead, addKnown)
	end
	table.sort(list, function(a,b) return service.person2person_distance(a, id)<service.person2person_distance(b, id) end)
calls.leave("service.getLootList",id)
	return list
end,
-------------------------------------------------
getClosestDying = function(id,checkAll)	
calls.enter("service.getClosestDying",id)
	local distance = 100000
	local corpse = nil
	local idTeam = team(id)
	
	local find_body = function(index,value)
		if(	IsAlive(value.id) and
			(not healthOK(value.id)) and
			(relations(idTeam,team(value.id))==ALLY) and
			((Humans[value.id].healed == nil) or (Humans[value.id].healed == id)) and
			(checkAll or canOneSeeOther(id,value.id))) then
			local dist = service.person2person_distance(id,value.id)
			if(dist<distance) then
				distance = dist
				corpse = value.id
			end
		end
	end
	
	table.foreach(Humans,find_body)
calls.leave("service.getClosestDying",id)
	return corpse, distance
end,
-------------------------------------------------
--     
isTargetDangerous = function(target)
calls.enter("service.isTargetDangerous",target)
	local ret = false
	if(isUnitValid(target)) then
		local armed = (getGun(target, -1) == getHandIndex(target))
		ret = healthOK(target) and (armed or service.isPlayer(target) or Humans[target].dangerous)
	end
calls.leave("service.isTargetDangerous",ret)
	return(ret)
end,
-------------------------------------------------
--       
getDangerousEnemyList = function(id)
calls.enter("service.getDangerousEnemyList",id)
	local list = {}

	local checkGun = function(index, human)
		if((Humans[id].visible_enemies[human.id] or
			service.checkIfVisibleInRange(id, human.id, 30)) and
			service.isTargetDangerous(human.id)) then
			table.insert(list, human.id)
		end
	end

	if(isValid(Humans[id])) then
		table.foreach(Humans, checkGun)
	end
calls.leave("service.getDangerousEnemyList",id)	
	return list
end,
-------------------------------------------------
--      
getHumanListInRange = function(id, rel, visible, range)	
calls.enter("service.getHumanListInRange",id)
	local list = service.getHumanList(id,rel,visible)
	local new_list = {}
	
	local find_human_in_range = function(index,value)
		if(service.person2person_distance(value, id)<range) then
			table.insert(new_list,value)
		end
	end
	
	table.foreach(list,find_human_in_range)
calls.leave("service.getHumanListInRange",id)
	return new_list
end,
-------------------------------------------------
getEATandFATInRangeForPoint = function(id, x, y, z, range)	
calls.enter("service.getEATandFATInRangePoint",id)
	local res = 0
	local allies = 0
	local enemies = 0
	local ally_list = service.getHumanList(id, "ally", false)
	local enemy_list = service.getHumanList(id, "enemy", true)
	
	local add_known = function(index,value)
		if ((service.point2point_distance(x, y, z, value.x, value.y, value.z) <= range)) then
log(id,"*** Add known enemy",value.id)
			enemies = enemies + 1
		end
	end

	local count_ally = function(index,value)
		if(service.person2point_distance(value, x, y, z) <= range) then
log(id,"*** Add ally",value)
			allies = allies + 1
		end
	end
	
	local count_enemy = function(index,value)
		if(service.person2point_distance(value, x, y, z) <= range) then
log(id,"*** Add enemy",value)
			enemies = enemies + 1
		end
	end
	
	table.foreach(enemy_list, count_enemy)	
	table.foreach(ally_list, count_ally)
	table.foreach(Humans[id].memory.known_enemies, add_known)
	
	res = ((allies+1) / (2*enemies))-0.5
log(id,"*** result:",allies,enemies,res)
calls.leave("service.getEATandFATInRangePoint",res)
	return res
end,

-------------------------------------------------
--          
getEATandFATInRange = function(id, target, range)	
calls.enter("service.getEATandFATInRange",id)
	local res = 0
	local allies = 0
	local enemies = 0
	local ally_list = service.getHumanList(id, "ally", false)
	local enemy_list = service.getHumanList(id, "enemy", true)
	
	local add_known = function(index,value)
		if ((service.person2point_distance(target, value.x, value.y, value.z) <= range)) then
log(id,"*** Add known enemy",value.id)
			enemies = enemies + 1
		end
	end

	local count_ally = function(index,value)
		if(service.person2person_distance(value, target) <= range) then
log(id,"*** Add ally",value)
			allies = allies + 1
		end
	end
	
	local count_enemy = function(index,value)
		if(service.person2person_distance(value, target) <= range) then
log(id,"*** Add enemy",value)
			enemies = enemies + 1
		end
	end
	
	table.foreach(enemy_list, count_enemy)	
	table.foreach(ally_list, count_ally)
	table.foreach(Humans[id].memory.known_enemies, add_known)
	
	res = ((allies+1) / (2*enemies))-0.5
calls.leave("service.getEATandFATInRange",res)
log(id,"*** result:",allies,enemies,res)
	return res
end,
-------------------------------------------------
--   
isCivilian = function(id)
calls.enter("service.isCivilian",id)
	local ret = false
	if(isValid(Humans[id])) then
		local behavior = Humans[id].behavior
		local specialization = Humans[id].specialization
		ret = ((behavior == "npc") or 
			(behavior == "civilian") or 
			(behavior == "home") or 
			(behavior == "wandering") or 
			(specialization == "civilian"))
	end
calls.leave("service.isCivilian",0)
	return(ret)
end,
-------------------------------------------------
--   
isPlayer = function(id)
calls.enter("service.isPlayer",id)
	local ret = (team(id)==PLAYER)
calls.leave("service.isPlayer",ret)
	return(ret)
end,
-------------------------------------------------
--

removeFromVisibleTeam = function(teamId, enemy)
calls.enter("service.removeFromVisibleTeam",teamId)
	local remove = function(index, name)
		if(team(name.id)==teamId) then
			service.removeFromVisibleL(name.id, enemy)
		end
	end

	table.foreach(Humans, remove)
calls.leave("service.removeFromVisibleTeam",teamId)
end,

removeFromVisibleG = function(id, enemy)
calls.enter("service.removeFromVisibleG",id)
	local friends = service.getHumanList(id, "ally", false)
	
	local remove = function(index, name)
		service.removeFromVisibleL(name, enemy)
	end

	table.foreach(friends, remove)
calls.leave("service.removeFromVisibleG",id)
end,
-------------------------------------------------
--			
removeFromVisibleL = function(name, enemy)
calls.enter("service.removeFromVisibleL",name)
	if(isValid(Humans[name]) and (Humans[name].visible_enemies~=nil)) then
		if(Humans[name].visible_enemies[enemy]) then
			Humans[name].visible_enemies[enemy] = false
			Humans[name].visible_enemies.size = Humans[name].visible_enemies.size - 1
			if (Humans[name].visible_enemies.size < 0) then
				Humans[name].visible_enemies.size = 0
			end
		end
	end
calls.leave("service.removeFromVisibleL",name)
end,
-------------------------------------------------
updateVisibleForTeam = function(team_id)
calls.enter("service.updateVisibleForTeam",team_id)
--	if(team_id~=PLAYER) then
--		local updateVisibilityForUnit = function(index, id)
--			if(healthOK(id)) then
--log(id,"*** Update visible for team",team_id,relations(team_id,PLAYER))
--				service.updateVisible(id)
--			end
--		end
--		table.foreach(service.getPlayerUnits(team_id), updateVisibilityForUnit)
--	end
calls.leave("service.updateVisibleForTeam",team_id)
end,
-------------------------------------------------
updateVisible = function(id)
calls.enter("service.updateVisible",id)
	local collectVisibleEnemies = function(index, human)
		if(	healthOK(human.id) and
			(relations(team(id),team(human.id))==ENEMY) and
			canOneSeeOther(id,human.id)) then
			if(service.addToVisible(id,human.id)) then
				log(id,"*** Update visible - ",human.id)
			end
		else
			if(not IsAlive(human.id)) then
				service.removeFromVisibleL(id, human.id)
			end
	        end
	end

	if(healthOK(id)) then
		table.foreach(Humans, collectVisibleEnemies)
	end
calls.leave("service.updateVisible",id)
end,
-------------------------------------------------
--
addToVisible = function(id, enemy)
calls.enter("service.addToVisible",id)
	local ret = false
	if(isValid(Humans[id]) and (enemy~=id)) then
		memory.addLastSeen(id, enemy)
		if(Humans[id].visible_enemies == nil) then
			Humans[id].visible_enemies = {}
			Humans[id].visible_enemies.size = 0
		end
		if(not Humans[id].visible_enemies[enemy]) then
			Humans[id].visible_enemies[enemy] = true
			Humans[id].visible_enemies.size = Humans[id].visible_enemies.size + 1
			ret = true
		end
	end
calls.leave("service.addToVisible",id)
	return(ret)
end,
-------------------------------------------------
checkIfVisibleInRange = function(id, enemy, range)
calls.enter("service.checkIfVisibleInRange",id)
	local res = false
	local id_team = team(id)
	local friends = service.getHumanListInRange(id, "ally", false, range)

	local check = function(index, name)
		if(healthOK(name) and
			Humans[name].visible_enemies and
			Humans[name].visible_enemies[enemy]) then
			res = true
			return(1)
		end
	end
	
	table.foreach(friends, check)
calls.leave("service.checkIfVisibleInRange")
	return res
end,
-------------------------------------------------
checkIfVisible = function(id, enemy, selfNeed)
calls.enter("service.checkIfVisible",id)
	local res = false
	local id_team = team(id)
	local friends = service.getHumanList(id, "ally", false)
	if(selfNeed) then
		table.insert(friends,id)
	end
	
	local check = function(index, name)
		if(healthOK(name) and
			Humans[name].visible_enemies and
			Humans[name].visible_enemies[enemy]) then
			res = true
			return(1)
		end
	end
	
	table.foreach(friends, check)
calls.leave("service.checkIfVisible")
	return res
end,
-------------------------------------------------
--
reloadCheck = function(id, gun_index, visible_target)
calls.enter("service.reloadCheck",id)
	local ammoPercent 		= service.ammoLeft(id, gun_index, 1, true)
	local ammoActual 		= service.ammoLeft(id, gun_index, 1, false)
	local reloadThreshold 	= getAIConst().reloadTreshold
	local weaponClipsize 	= service.clipSize(id, gun_index)
	
	log(id, "", ammoPercent, "%   . :", ammoActual, "/", weaponClipsize)

	if ((ammoPercent <= reloadThreshold) and (ammoPercent > 0) and (not isUnitValid(visible_target))) then
		log(id, "  ")
		if(service.isSniper(id)) then
			if(ammoPercent ~= 0) then
				log(id, "   .")
			end
		else
			if(service.canReload(id, gun_index, 1)) then
				log(id, "  ")
				addReload(id, gun_index, 1)
calls.leave("service.reloadCheck",1)
				return true
			else
				log(id, " .")
				local res = service.lootCheck(id)
calls.leave("service.reloadCheck")
				return res
			end
		end
	elseif(isUnitValid(visible_target) and (ammoPercent > 0) and (ammoActual ~= weaponClipsize)) then
		log(id, "   -  !")
	elseif(ammoPercent == 0) then
		log(id, "   !")
		if(service.canReload(id, gun_index, 1)) then
			log(id, "  ")
			addReload(id, gun_index, 1)
calls.leave("service.reloadCheck",1)
			return true
		end
	elseif(ammoActual == weaponClipsize) then
		log(id, " ")
	end
calls.leave("service.reloadCheck",0)
	return false
end,
-------------------------------------------------
--

getHealthPercent = function(id)
	local health 		= getPersonParameter(id, "HEALTH") 
	local fullhealth 	= getPersonParameter(id, "DURABILITYMAX")
	local healthPercent 	= math.floor(100 * health / fullhealth)
	return(healthPercent)
end,

retreatCheck = function(id)
calls.enter("service.retreatCheck",id)
	if(     (Humans[id].surroundTurnsForSkip==nil) or
		(Humans[id].surroundTurnsForSkip <= 0)) then
		Humans[id].surroundTurnsForSkip = 0	
		local achtung,direction	= service.isSurrounded(id)
		local dangerous_targets = service.getDangerousEnemyList(id)
		local allies = service.getHumanListInRange(id, ALLY, false, 15)
		local enemies_number 	= table.getn(dangerous_targets)
		local allies_number 	= table.getn(allies)

		local healthPercent 	= service.getHealthPercent(id)
		local retreatHealth 	= getAIConst().retreatHealth
		local retreatEnemies 	= getAIConst().retreatEnemies
		local retreat_rnd 	= math.random()
		local rnd_threshold1 	= getAIConst().surManyEnemiesSoldier
		local rnd_threshold2 	= getAIConst().surBadHealthSoldier

		if(service.isSniper(id) or service.isPatrol(id) or service.isLeader(id)) then
			rnd_threshold1 = getAIConst().surManyEnemiesSniper
			rnd_threshold2 = getAIConst().surBadHealthSniper
			retreatEnemies = getAIConst().retreatEnemiesSniper
		end

		local morale = getPersonParameter(id, "MORALE")
log(id,"morale:",morale)
log(id,"rnd_threshold1 without morale",rnd_threshold1,"rnd_threshold2 without morale",rnd_threshold2)
		rnd_threshold1 = rnd_threshold1*100/morale
		rnd_threshold2 = rnd_threshold2*100/morale
log(id,"rnd_threshold1 with morale",rnd_threshold1,"rnd_threshold2 with morale",rnd_threshold2)

		if(enemies_number-allies_number > retreatEnemies) then
			log(id, "  : ",enemies_number," allies: ",allies_number)
			if(achtung) then
				Humans[id].surrounded = true
			elseif((retreat_rnd < rnd_threshold1) or
				(healthPercent <= retreatHealth)) then
				log(id, "  : ",direction)
				Humans[id].surrounded = direction
				Humans[id].surroundTurnsForSkip = getAIConst().surroundTurns
			else
				Humans[id].surrounded = false
			end
		elseif(healthPercent <= retreatHealth) then
			log(id, " ",healthPercent,"% .")
			if(achtung) then
				Humans[id].surrounded = true
			elseif(retreat_rnd < rnd_threshold2) then
				log(id, "  : ",direction)
				Humans[id].surrounded = direction
				Humans[id].surroundTurnsForSkip = getAIConst().surroundTurns
			else
				Humans[id].surrounded = false
			end
		else
			Humans[id].surrounded = false
		end
	else
		log(id,"Skip surround interval", Humans[id].surroundTurnsForSkip)
		local achtung,direction	= service.isSurrounded(id)
		if(achtung) then
			Humans[id].surrounded = "ahead"
		else
			Humans[id].surrounded = direction
		end
	end
calls.leave("service.retreatCheck",id)
end,

processSoundEvent = function(id, stype, x, y, z, owner, time)
calls.enter("service.processSoundEvent",id)
	--
	if( isUnitValid(owner) and
		isUnitValid(id) and
		(relations(team(owner),team(id))~=ALLY) and
		(not service.isPlayer(id)) and
		healthOK(id)) then
		local dist = service.person2point_distance(id, x, y, z)
		local x1,y1,z1,f1 = getPosition(owner)
		sounds.addSound(id,time,stype, x, y, z, f1, owner)
		local rnd = math.random()
		if(sounds.isSoundDangerous(stype,dist)) then
		        rnd = 1.0
		end
		if(stype == "bullet") then
			if (Humans[id].status == "GREEN") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd > 0.5) then
					Humans[id].status = "YELLOW"
					log(id, "NEW STATUS:", Humans[id].status)
				else
					log(id, "... .")
calls.leave("service.processSoundEvent",id)
					return
				end
			elseif (Humans[id].status == "YELLOW") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd < 0.25) then
					log(id, "... .")
					Humans[id].status = "GREEN"
					log(id, "NEW STATUS:", Humans[id].status)
calls.leave("service.processSoundEvent",id)
					return
				end
			end
        		if (rnd > 0.75) then
				log(id, "ALERT!!!")
				service.alertFriends(id, "YELLOW")
			end
		elseif(stype == "shot") then
			if (Humans[id].status == "GREEN") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd > 0.35) then
					Humans[id].status = "YELLOW"
					log(id, "NEW STATUS:", Humans[id].status)
				else
					log(id, "... .")
calls.leave("service.processSoundEvent",id)
					return
				end
			elseif (Humans[id].status == "YELLOW") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd < 0.15) then
					log(id, "... .")
					Humans[id].status = "GREEN"
					log(id, "NEW STATUS:", Humans[id].status)
calls.leave("service.processSoundEvent",id)
					return
				end
			end
			if (rnd > 0.5) then
				log(id, "ALERT!!!")
				service.alertFriends(id, "YELLOW")
			end
		elseif (stype == "step") then
			if (Humans[id].status == "GREEN") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd > 0.75) then
					Humans[id].status = "YELLOW"
					log(id, "NEW STATUS:", Humans[id].status)
				else
					log(id, "... .")
calls.leave("service.processSoundEvent",id)
					return
				end
			elseif (Humans[id].status == "YELLOW") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd < 0.5) then
					log(id, "... .")
					Humans[id].status = "GREEN"
					log(id, "NEW STATUS:", Humans[id].status)
calls.leave("service.processSoundEvent",id)
					return
				end
			end
			if (rnd > 0.95) then
				log(id, "ALERT!!!")
				service.alertFriends(id, "YELLOW")
			end
		elseif (stype == "blast") then
			if (Humans[id].status == "GREEN") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd > 0.25) then
					Humans[id].status = "YELLOW"
					log(id, "NEW STATUS:", Humans[id].status)
				else
					log(id, "... .")
calls.leave("service.processSoundEvent",id)
					return
				end
			elseif (Humans[id].status == "YELLOW") then
				log(id, "CURRENT STATUS:", Humans[id].status)
				if (rnd < 0.05) then
					log(id, "... .")
					Humans[id].status = "GREEN"
					log(id, "NEW STATUS:", Humans[id].status)
calls.leave("service.processSoundEvent",id)
					return
				end
			end
			if (rnd > 0.40) then
				log(id, "ALERT!!!")
				service.alertFriends(id, "YELLOW")
			end
		else
			log(id, "Unknown sound type", stype)
		end
	end
calls.leave("service.processSoundEvent",id)
end,

incrementHate = function(id, attacker, delta)
calls.enter("service.incrementHate",id)
	if(delta==nil) then
		delta = 1
	end
	local team_attacker = team(attacker)
	local times = Humans[id].hates_person[attacker]
	if(times == nil) then
		times = 0
	end
	local force = Humans[id].hates_force[team_attacker]
	if(force == nil) then
		force = 0
	end
	force = force + delta*2/3
	times = times + delta
	Humans[id].hates_force[team_attacker] = force
	Humans[id].hates_person[attacker] = times
	log("hurt_observer",id,"More hate for",attacker,times,force)
calls.leave("service.incrementHate",id)
	return times,force
end,

isHateThem = function(id, victim)
calls.enter("service.isHateThem",id)
        local team_victim = team(victim)
	local hates = Humans[id].hates_person[victim]
	local force = Humans[id].hates_force[team_victim]
	if(hates == nil) then
		hates = 0
	end
        if(force == nil) then
		force = 0
	end
calls.leave("service.isHateThem",id)
	return( (hates>2) or (force>2) )
end,

sayWoundedRemark = function(id,attacker)
calls.enter("service.sayWoundedRemark",id)
	if(math.random() < 0.5) then
		local sex_litera = ""
		local who = "enemy"
		local sex = getPersonParameterStr(attacker, "SEX")
		if (string.lower(sex) == "female") then
			sex_litera = "f_"
		end
		if (service.isSniper(id) == true) then
			who = "sniper"
		elseif (service.isPatrol(id) == true) then
			who = "patrol"
		elseif (service.isLeader(id) == true) then
			who = "leader"
		elseif (service.isCivilian(id) == true) then
			who = "civilian"
		end
		local count = math.random(5)
		local remark = sex_litera..who.."_wounded_0"..count
		service.showAck(id, remark, 1.0)
	end
calls.leave("service.sayWoundedRemark",id)
end,

processHurtEvent = function(id, x, y, z, attacker)
calls.enter("service.processHurtEvent",id)
	if((not isUnitValid(attacker)) or (not isUnitValid(id))) then
calls.leave("service.processHurtEvent",id)
		return
	end

	Humans[id].hurt = attacker
	local team_id = team(id)
	local team_attacker = team(attacker)
	local onVictimEyes = (healthOK(id) and canOneSeeOther(id, attacker))
	local remarker = nil
	if(onVictimEyes) then
		remarker = id
	end				

	if(team_id ~= team_attacker) then

		local log_id = "hurt_observer"
		log(id, "HURT_EVENT: Check", log_id, "log]")
		log(log_id, ">>>", id, "HURT PROCESSING STARTED<<<")

		local rel_id_attacker = relations(team_id, team_attacker)
		if(rel_id_attacker ~= ENEMY) then

			local witnessCheck = function(index, witness)
				local witnessSeeVictim = canOneSeeOther(witness, id)
				local witnessSeeAttacker = canOneSeeOther(witness, attacker)
				if( witnessSeeAttacker or witnessSeeVictim ) then
					local dist  = service.person2person_distance(witness, attacker)
				        local w_t,w_f = service.incrementHate(witness,attacker)
					if( witnessSeeAttacker ) then
						if( ((math.random() * (w_t + 1)) > 1) or (not healthOK(id)) ) then
							log(log_id, witness, "(witness): putting on target list",w_t,w_f)
							service.addToVisible(witness, attacker)
							Humans[witness].status = "RED"
						end
						if(remarker==nil) then
							remarker = witness
						end
					end
					if(((math.random() * (w_f + 1)) > 2) 
--						or (dist<7)
						) then
						log(log_id, witness, "(witness): Enough is enough! This means WAR!!!",w_f,w_t)
						relationsChange(team_id, team_attacker, ENEMY)
						relationsChange(team_attacker, team_id, ENEMY)
					end

				end
			end

			local buddies = service.getHumanList(id, "ally", false)
			table.foreach(buddies, witnessCheck)
			local times,force = service.incrementHate(id,attacker)

			if(onVictimEyes) then
				if(times > 1) then
					log(log_id, id, "(onVictimEyes) putting on target list",times,force)
					service.addToVisible(id, attacker)
					Humans[id].status = "RED"
				end
				if(force > 2) then
					log(log_id, id, "(onVictimEyes): Enough is enough! This means WAR!!!",force,times)
					relationsChange(team_id, team_attacker, ENEMY)
					relationsChange(team_attacker, team_id, ENEMY)
				end
			end
			log(log_id, ">>>", id, ": HURT PROCESSING FINISHED<<<")
		end
	end	

	if(remarker~=nil) then
		service.sayWoundedRemark(remarker,attacker)
	end
calls.leave("service.processHurtEvent",id)
end,
-------------------------------------------------
--
lootCheck = function(id,noAmmoCheck)
calls.enter("service.lootCheck",id)
	local loot_list = service.getLootList(id,(not isGameInRT()))
	local loot_list_size = table.getn(loot_list)
	local ret = false
	local current_loot = NONE
	
	if(loot_list_size > 0) then
		if(Humans[id].freeze>2) then
			current_loot = loot_list[1]
			log(id,"Freezed, ",Humans[id].freeze," mark ",current_loot," as unreachiable")
			Humans[id].freeze = 0
			Humans[current_loot].looted = "unreachiable"
			ret = service.lootCheck(id,noAmmoCheck)	
		else
			local gun_index = getGun(id, -1)
			if(gun_index<0) then
				gun_index = getHandIndex(id)
			end 
			local slot = -1
			local addSlot = -1
			log(id, "   :", loot_list_size, Humans[id].freeze)
			if(not noAmmoCheck) then
				log(id, "  .")
				for count = 1, loot_list_size, 1 do
					local loot = loot_list[count]
					local test = findClipForMyGun(id, gun_index, "primary", loot)
					if((test >= 0) and 
						((not isUnitValid(Humans[loot].looted)) or (Humans[loot].looted==id))) then
						loot_list_size = count
						slot = test
						current_loot = loot
						log(id, "Founded ammo",loot)
						break
					end
				end
			end
			for count = 1, loot_list_size, 1 do
				local loot = loot_list[count]
				local test = findBetterGun(id, loot)
				if((test >= 0) and 
					((not isUnitValid(Humans[loot].looted)) or (Humans[loot].looted==id))) then
					if(current_loot == loot) then
						log(id, "Founded weapon and ammo",loot)
						addSlot = slot
					else
						log(id, "Founded weapon",loot)
						current_loot = loot
					end
        				slot = test
					break
				end
			end
			if(slot>=0) then
				Humans[current_loot].looted = id
				Humans[id].moveonly = true
				Humans[id].attacked = false
				local rel = relations(team(current_loot),team(id))
				if((rel==ENEMY) and 
					IsAlive(current_loot) and
					getAIConst().tryKillDyingEnemy) then
					log(id, "Kill dying enemy.",current_loot)
					meleeAttack(id, current_loot)	
					Humans[id].attacked = true
				else
					local x,y,z,f = getPosition(current_loot)
					local dist = service.person2person_distance(id, current_loot)
					if(dist > 3) then
						if(isGameInRT() or (math.random()<0.5)) then
							addPose(id, "stand")
						else
							log(id, "    ",dist)
							local bx, by, bz = service.pointAlongPersonToPersonLine(id, current_loot, service.getRealRand(1,3))
							addSmartMove(id, "run", bx, by, bz, f)
calls.leave("service.lootCheck",1)
							return(true)
						end     	
					else
						addRotate(id,x,y,z)
					end
				end
				addLoot(id, current_loot, slot)
				if(addSlot>=0) then
					addLoot(id, current_loot, addSlot)
				end
				addSlot = getGrenade(current_loot,"grenade")
				if(addSlot>=0) then
					addLoot(id, current_loot, addSlot)
				end
				addPose(id, "sit")
				ret = true
			else
				log(id, "Not found.")
				current_loot = loot_list[1]
				local dist = service.person2person_distance(id, current_loot)
				if((dist <= 3) and 
					(getPersonPose(id)=="sit") and
					(Humans[current_loot].looted == id)) then
					if(IsAlive(current_loot)) then
						local rel = relations(team(current_loot),team(id))
						if((rel==ALLY) and getAIConst().tryHealAlly) then
							b_soldier.bandageHuman(id,current_loot)
						end
					end
					if(isGameInRT()) then
						log(id, "Walk from last looted.")
						Humans[current_loot].looted = NONE
						local bx, by, bz, bf = getPosition(id)
						bx, by, bz = service.randomPointAroundPoint(bx, by, bz, service.getRealRand(-30,30))
						addSmartMove(id, "walk", bx, by, bz, bf)
						Humans[id].moveonly = true
						Humans[id].attacked = false
						ret = true
					end
				end
			end
		end
	end
calls.leave("service.lootCheck",1)
	return(ret)
end,
------------------------------------------------- 
getRealRand = function(lo,hi)
	return(math.random()*(hi-lo)+lo)
end,
------------------------------------------------- 

lastTimeAck = -10000,

showAck = function(id,comment,probability,priority,sequence)
calls.enter("service.showAck",id)
	if(service.lastTimeAck>time()) then
		service.lastTimeAck = -10000
	end
	local situation = string.sub(comment,1,string.len(comment)-3)

	if(service.isPlayer(id)) then
		log("acks",situation)
	end

	local rnd = math.random()
	if(	(LAST_REMARK ~= situation) and
		IsAlive(id) and
		(Humans[id].last_remark~=comment) and
		(rnd < probability)) then
		local where = table_values.over_head
		if(service.isPlayer(id)) then
			if(time()-service.lastTimeAck<2) then
calls.leave("service.showAck",2)
				return(false)
			end
			service.lastTimeAck = time()
			where = table_values.corner
			LAST_REMARK = situation
		end
		Humans[id].last_remark = comment
		showComments(id, comment, where, priority, sequence, 0)
calls.leave("service.showAck",1)
		return(true)
	end
	if(time()-service.lastTimeAck>5) then
		LAST_REMARK = NONE
	end
calls.leave("service.showAck",0)
	return(false)
end,

pointAtLeftOf = function( x, y, x1, y1, x2, y2 )
	if(x1==x2) then
		return(x<x1)
	elseif(y1==y2) then
		return(false)
	else
		local a = (y1-y2)/(x1-x2)
		local b = y1 - a*x1
		local x3 = (y-b)/a
		return(x<x3)
	end
end,

pointAtTopOf = function( x, y, x1, y1, x2, y2 )
	if(y1==y2) then
		return(y>y1)
	elseif(x1==x2) then
		return(false)
	else
		local a = (y1-y2)/(x1-x2)
		local b = y1 - a*x1
		local y3 = a*x+b
		return(y>y3)
	end
end,

isPointInBlackZone = function( x, y )
	if(isValid(CUR_MISSION.Name) and
		isValid(Sectors[CUR_MISSION.Name]) and
		isValid(Sectors[CUR_MISSION.Name].lb) and
		isValid(Sectors[CUR_MISSION.Name].rb) and
		isValid(Sectors[CUR_MISSION.Name].lt) and
		isValid(Sectors[CUR_MISSION.Name].rt)) then
		return(
			service.pointAtLeftOf(x,y,
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y) or
			(not service.pointAtLeftOf(x,y,
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)) or
			service.pointAtTopOf(x,y,
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y) or
			(not service.pointAtTopOf(x,y,
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y)))
	end
	return(false)
end,

isUnitInBlackZone = function( id )
	local x, y, z, f = getPosition(id)
	return(service.isPointInBlackZone(x,y))
end,

checkPointForBorders = function( sx, sy, tx, ty )

	local getRoot = function( x11, y11, x12, y12, x21, y21, x22, y22 )
		local x = 0
		local y = 0
		if(x11==x12) then
			if(x21==x22) then
				x = x22
				y = y22
			else
				x = x11
				local c = (y21-y22)/(x21-x22)
				local d = y22 - c*x22
				y = x*c+d
			end
		else
			local a = (y11-y12)/(x11-x12)
			local b = y11 - a*x11
			local c = (y21-y22)/(x21-x22)
			local d = y22 - c*x22
			if(a~=c) then
				x = (d-b)/(a-c)
				y = x*c+d
			end
		end
		return x,y
	end

	if(isValid(CUR_MISSION.Name) and
		isValid(Sectors[CUR_MISSION.Name]) and
		isValid(Sectors[CUR_MISSION.Name].lb) and
		isValid(Sectors[CUR_MISSION.Name].rb) and
		isValid(Sectors[CUR_MISSION.Name].lt) and
		isValid(Sectors[CUR_MISSION.Name].rt)) then

		if(service.pointAtLeftOf(tx,ty,
			Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
			Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y)) then

			if(service.pointAtLeftOf(sx,sy,
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y)) then
				return tx,ty
			end

			log("borders","At left of border was ",tx,ty)
			tx,ty = getRoot( sx, sy, tx, ty, 
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y )
			log("borders","At left of border now ",tx,ty)
		end
		if(not service.pointAtLeftOf(tx-0.5,ty,
			Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y,
			Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)) then

			if(not service.pointAtLeftOf(sx-0.5,sy,
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)) then
				return tx,ty
			end	

			log("borders","At right of border was ",tx,ty)
			tx,ty = getRoot( sx, sy, tx-0.5, ty, 
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)
			log("borders","At right of border now ",tx,ty)
		end
		if(service.pointAtTopOf(tx,ty,
			Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y,
			Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)) then

			if(service.pointAtTopOf(sx,sy,
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)) then
				return tx,ty
			end

			log("borders","At up of border was ",tx,ty)
			tx,ty = getRoot( sx, sy, tx, ty, 
				Sectors[CUR_MISSION.Name].lt.x,Sectors[CUR_MISSION.Name].lt.y,
				Sectors[CUR_MISSION.Name].rt.x,Sectors[CUR_MISSION.Name].rt.y)
			log("borders","At up of border now ",tx,ty)
		end
		if(not service.pointAtTopOf(tx,ty-0.5,
			Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
			Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y)) then

			if(not service.pointAtTopOf(sx,sy-0.5,
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y)) then
				return tx,ty
			end

			log("borders","At below of border was ",tx,ty)
			tx,ty = getRoot( sx, sy, tx, ty-0.5, 
				Sectors[CUR_MISSION.Name].lb.x,Sectors[CUR_MISSION.Name].lb.y,
				Sectors[CUR_MISSION.Name].rb.x,Sectors[CUR_MISSION.Name].rb.y)
		        log("borders","At below of border now ",tx,ty)
		end
	end
	return tx,ty
end,

checkUnitForBorders = function( id, tx, ty )
	local sx, sy, sz, sf = getPosition(id)
	return service.checkPointForBorders( sx, sy, tx, ty )
end

}
